<?php
// ===== NÃO IMPRIMA NADA ANTES DESTE PONTO =====

// --- Helpers de compatibilidade ---
if (!function_exists('starts_with_https')) {
    function starts_with_https(string $url): bool {
        return stripos($url, 'https://') === 0;
    }
}

// --- Validações de entrada ---
if (!isset($_GET['vl'])) { if (!headers_sent()) http_response_code(400); exit('vl nao existe'); }
if ($_GET['vl'] === '' || !is_numeric($_GET['vl'])) { if (!headers_sent()) http_response_code(400); exit('vl não pode ser vazio, e tem que ser numerico'); }

$amountRaw = (float) $_GET['vl'];
if ($amountRaw < 1 || $amountRaw > 100) { if (!headers_sent()) http_response_code(400); exit('valor deve ser entre 1 e 100'); }

// --- Carrega dependências ---
$config = require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../class/Conn.class.php';
require_once __DIR__ . '/../class/Payment.class.php';

// --- Parâmetros opcionais ---
$user_id = $_GET['user_id'] ?? null;
$tipo    = $_GET['tipo']    ?? null;

// --- Cria registro interno (tabela payment) ---
$payment   = new Payment($user_id);
$payCreate = $payment->addPayment($amountRaw, $tipo);
if (!$payCreate) { if (!headers_sent()) http_response_code(500); exit('Falha ao criar registro de pagamento.'); }

// --- Token do Mercado Pago ---
$accessToken = $config['accesstoken'] ?? null;
if (!$accessToken) { if (!headers_sent()) http_response_code(500); exit('Access token do Mercado Pago não configurado.'); }

// --- notification_url somente se for https público válido ---
$notifUrl = $config['url_notification_api'] ?? null;
$hasValidNotif = is_string($notifUrl) && filter_var($notifUrl, FILTER_VALIDATE_URL) && starts_with_https($notifUrl);

// --- (Opcional) validação de documento se for enviado por GET ---
function cpfValido($cpf): bool {
    $cpf = preg_replace('/\D/', '', (string)$cpf);
    if (strlen($cpf) != 11 || preg_match('/^(\\d)\\1{10}$/', $cpf)) return false;
    for ($t = 9; $t < 11; $t++) {
        $d = 0;
        for ($c = 0; $c < $t; $c++) $d += (int)$cpf[$c] * (($t + 1) - $c);
        $d = ((10 * $d) % 11) % 10;
        if ((int)$cpf[$t] !== $d) return false;
    }
    return true;
}
function cnpjValido($cnpj): bool {
    $cnpj = preg_replace('/\D/', '', (string)$cnpj);
    if (strlen($cnpj) != 14) return false;
    $t = [5,4,3,2,9,8,7,6,5,4,3,2];
    $s = 0; for ($i=0;$i<12;$i++) $s += (int)$cnpj[$i]*$t[$i];
    $d1 = ($s%11<2)?0:11-($s%11);
    $t = [6,5,4,3,2,9,8,7,6,5,4,3,2];
    $s = 0; for ($i=0;$i<13;$i++) $s += (int)$cnpj[$i]*$t[$i];
    $d2 = ($s%11<2)?0:11-($s%11);
    return ((int)$cnpj[12]===$d1 && (int)$cnpj[13]===$d2);
}

// --- Monta payload do pagamento PIX ---
$payload = [
    'description'         => 'Pagamento PIX',
    'external_reference'  => (string)$payCreate,    // ID interno do seu registro
    'payment_method_id'   => 'pix',
    'transaction_amount'  => (float)$amountRaw,
    'payer'               => [
        // Email genérico; substitua se tiver o email real do pagador
        'email' => 'pagador@example.com',
    ],
];
if ($hasValidNotif) {
    $payload['notification_url'] = $notifUrl;
}

// Se você enviar documento por GET (&doc=...&doc_type=CPF|CNPJ), só inclui se for válido
$doc = $_GET['doc'] ?? null;
$docType = strtoupper((string)($_GET['doc_type'] ?? ''));
if ($doc && ($docType === 'CPF' || $docType === 'CNPJ')) {
    $digits = preg_replace('/\D/', '', $doc);
    $ok = ($docType === 'CPF' && cpfValido($digits)) || ($docType === 'CNPJ' && cnpjValido($digits));
    if ($ok) {
        $payload['payer']['identification'] = [
            'type'   => $docType,
            'number' => $digits,
        ];
    }
}

// --- Chamada ao MP ---
$pixUrl  = 'https://api.mercadopago.com/v1/payments';
$chars   = '123456789ABCDFGHIJKLMNPQRSTUVXYZ';
$idemKey = substr(str_shuffle($chars), 0, 5) . '-' . substr(str_shuffle($chars), 0, 8) . '-' . substr(str_shuffle($chars), 0, 4);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL            => $pixUrl,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_MAXREDIRS      => 10,
    CURLOPT_TIMEOUT        => 30,
    CURLOPT_CUSTOMREQUEST  => 'POST',
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken,
        'X-Idempotency-Key: ' . $idemKey,
    ],
]);
$response  = curl_exec($ch);
$curlErr   = curl_error($ch);
$httpCode  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($curlErr) { if (!headers_sent()) http_response_code(502); exit('Erro cURL: ' . $curlErr); }

$obj = json_decode($response);

// --- Tratamento de erro do MP (mensagem sem id) ---
if (isset($obj->message) && !isset($obj->id)) {
    if (!headers_sent()) http_response_code($httpCode ?: 400);
    exit('Erro Mercado Pago: ' . $obj->message);
}

// --- Sucesso: tenta redirecionar para ticket_url ---
if (isset($obj->id) && isset($obj->point_of_interaction->transaction_data)) {
    $tx = $obj->point_of_interaction->transaction_data;
    $ticketUrl = $tx->ticket_url ?? null;

    if ($ticketUrl) {
        header('Location: ' . $ticketUrl, true, 303); // redireciona para o link externo do PIX
        exit;
    }

    // ===== Plano B: sem ticket_url, exibe QR, copia-e-cola e status =====
    $qrBase64  = $tx->qr_code_base64 ?? null;
    $qrCode    = $tx->qr_code ?? null;

    // Puxa status atual do seu DB (opcional)
    try {
        $pdo = DB::getInstance();
        $st  = $pdo->prepare('SELECT status FROM `payment` WHERE id = :id');
        $st->bindValue(':id', $payCreate, PDO::PARAM_INT);
        $st->execute();
        $paymentStatus = $st->fetch(PDO::FETCH_ASSOC)['status'] ?? 'pending';
    } catch (Throwable $e) {
        $paymentStatus = 'pending';
    }

    ?>
    <!doctype html>
    <html lang="pt-BR">
    <head>
        <meta charset="utf-8">
        <title>Pagamento PIX</title>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <style>
            body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,'Helvetica Neue',Arial,sans-serif;background:#0f1115;color:#e5e7eb;margin:0}
            .container{max-width:560px;margin:40px auto;padding:24px;background:#111320;border:1px solid #1f2430;border-radius:16px}
            h3{margin:0 0 12px 0}
            .qrcode-container{display:flex;justify-content:center;margin:16px 0}
            .centered-content{text-align:center}
            textarea{width:100%;height:120px;background:#0b0e17;color:#e5e7eb;border:1px solid #1f2430;border-radius:8px;padding:10px}
            a.button{display:inline-block;margin-top:12px;padding:10px 16px;border-radius:10px;border:1px solid #334155;text-decoration:none;color:#e5e7eb}
            #payment-status{padding:2px 8px;border-radius:999px;border:1px solid #334155}
            .approved{color:#22c55e;border-color:#22c55e}
            .pending{color:#fbbf24;border-color:#fbbf24}
            .rejected{color:#ef4444;border-color:#ef4444}
        </style>
    </head>
    <body>
        <div class="container">
            <h3>PIX gerado — referência #<?php echo htmlspecialchars((string)$payCreate); ?></h3>
            <p>Status: <span id="payment-status" class="<?php echo htmlspecialchars($paymentStatus); ?>"><?php echo htmlspecialchars($paymentStatus); ?></span></p>

            <?php if ($qrBase64): ?>
                <div class="qrcode-container">
                    <img src="data:image/png;base64,<?php echo htmlspecialchars($qrBase64); ?>" alt="QR Code PIX" />
                </div>
            <?php endif; ?>

            <?php if ($qrCode): ?>
                <div class="centered-content">
                    <p>Ou copie o código PIX abaixo e pague no seu banco:</p>
                    <textarea readonly><?php echo htmlspecialchars($qrCode); ?></textarea>
                </div>
            <?php endif; ?>

            <div class="centered-content">
                <a class="button" href="/" rel="nofollow">Voltar</a>
            </div>
        </div>

        <script>
        // Poll do status a cada 5s (ajuste a URL se necessário)
        setInterval(function() {
            var xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function() {
                if (this.readyState === 4 && this.status === 200) {
                    var status = this.responseText || 'pending';
                    var el = document.getElementById('payment-status');
                    if (el) { el.textContent = status; el.className = status; }
                }
            };
            xhr.open('GET', 'get_payment_status.php?external_reference=<?php echo urlencode((string)$payCreate); ?>', true);
            xhr.send();
        }, 5000);
        </script>
    </body>
    </html>
    <?php
    exit;
}

// --- Falha inesperada: sem id/sem transaction_data ---
if (!headers_sent()) http_response_code(502);
exit('Resposta inesperada do Mercado Pago: ' . $response);