<?php

$config = require_once "../config.php";
require_once "../class/Conn.class.php";
require_once "../class/Payment.class.php";


$key_mp = $config["accesstoken"];

if (isset($_GET["id_transacao"])) {
    $codigo_transacao = $_GET["id_transacao"];
}else{
    die("ID DA TRANSAÇÃO DESCONHECIDA");
}



$user_id = $_GET["user_id"] ?? null;
$tipo = $_GET["tipo"] ?? null;

if (!$user_id || !is_numeric($user_id)) {
    die("user_id inválido");
}
if ($tipo === null || ($tipo != 0 && $tipo != 1)) {
    die("tipo inválido");
}

if (!isset($_GET["vl"])) {
    die("vl não existe");
} elseif ($_GET["vl"] == "" || !is_numeric($_GET["vl"])) {
    die("vl não pode ser vazio e tem que ser numérico");
} elseif ($_GET["vl"] < 1 || $_GET["vl"] > 100) {
    die("valor deve ser entre 1 e 100");
}



$valor = (float) trim($_GET["vl"]);

$payment = new Payment($user_id);

$payCreate = $payment->addPayment($valor, $tipo, $codigo_transacao);

if ($payCreate) {
    $ch = curl_init();

    curl_setopt_array($ch, [
        CURLOPT_URL => "https://api.mercadopago.com/checkout/preferences",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode([
            "back_urls" => [
                "success" => $config["url_success"],
                "pending" => "https://google.com/pending",
                "failure" => "https://google.com/failure",
            ],
            "external_reference" => $codigo_transacao,
            "notification_url" => $config["url_notification_api"],
            "auto_return" => "approved",
            "items" => [
                [
                    "title" => "Ragnarok",
                    "description" => "Dummy description",
                    "picture_url" => "http://www.myapp.com/myimage.jpg",
                    "category_id" => "car_electronics",
                    "quantity" => 1,
                    "currency_id" => "BRL",
                    "unit_price" => $valor,
                ],
            ],
            "payment_methods" => [
                "excluded_payment_types" => [["id" => "ticket"]],
            ],
        ]),
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "Authorization: Bearer " . $key_mp,
        ],
    ]);

    $response = curl_exec($ch);

    if ($response === false) {
        $error = curl_error($ch);
        curl_close($ch);
        die("Erro na solicitação cURL: " . $error);
    }
    curl_close($ch);

    $obj = json_decode($response);

    if ($response = curl_exec($ch)) {
        $obj = json_decode($response);
        if (isset($obj->init_point)) {
            echo "<script>window.location.href = '{$obj->init_point}';</script>";
            exit();
        }
    } else {
        echo "Erro na solicitação cURL: " . curl_error($ch);
        exit();
    }
}

?>
